<?php

namespace App\Http\Controllers;

use App\Http\Requests\ProfileUpdateRequest;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Redirect;
use Illuminate\View\View;
use App\Models\PaketPekerjaan;
use App\Models\OPD;
use App\Models\BadanUsaha;
use App\Models\TenagaAhli;
use App\Models\Pekerjaan;
class ProfileController extends Controller
{
    /**
     * Display the user's profile form.
     */


    public function info_grafis(Request $request): View
    {

        $statistikBulanan = collect();
        $statistikBulanan_n = collect();
        for ($i = 9; $i >= 0; $i--) {
            $bulan = now()->subMonths($i);
            $jumlahPaket = PaketPekerjaan::whereYear('created_at', $bulan->year)
                ->whereMonth('created_at', $bulan->month)
                ->count();

            $statistikBulanan_n->push([
               
                $jumlahPaket
            ]);

            $statistikBulanan->push([
                $bulan->format('M Y'),
              
            ]);
        }

        $pie[] = BadanUsaha::count();
        $pie[] = TenagaAhli::count();
       
     

        return view('profile.info_grafis',compact('statistikBulanan','statistikBulanan_n','pie'));
    }

    public function home(Request $request): View
    {
        return view('profile.home');
    }
    public function edit(Request $request): View
    {
        return view('profile.edit', [
            'user' => $request->user(),
        ]);
    }

    /**
     * Update the user's profile information.
     */
    public function update(ProfileUpdateRequest $request): RedirectResponse
    {
        $request->user()->fill($request->validated());

        if ($request->user()->isDirty('email')) {
            $request->user()->email_verified_at = null;
        }

        $request->user()->save();

        return Redirect::route('profile.edit')->with('status', 'profile-updated');
    }

    /**
     * Delete the user's account.
     */
    public function destroy(Request $request): RedirectResponse
    {
        $request->validateWithBag('userDeletion', [
            'password' => ['required', 'current_password'],
        ]);

        $user = $request->user();

        Auth::logout();

        $user->delete();

        $request->session()->invalidate();
        $request->session()->regenerateToken();

        return Redirect::to('/');
    }
}
