<?php

namespace App\Livewire;

use App\Models\PaketPekerjaan;
use App\Models\OPD;
use App\Models\BadanUsaha;
use App\Models\TenagaAhli;
use App\Models\Pekerjaan;
use Livewire\Component;
use Carbon\Carbon;

class Dashboard extends Component
{
    public function render()
    {
        // Statistik Paket Pekerjaan
        $totalPaket = PaketPekerjaan::count();
        $paketPerencanaan = PaketPekerjaan::where('status', 'perencanaan')->count();
        $paketTender = PaketPekerjaan::where('status', 'tender')->count();
        $paketProgres = PaketPekerjaan::where('status', 'progres')->count();
        $paketSelesai = PaketPekerjaan::where('status', 'selesai')->count();

        // Statistik Nilai Kontrak
        $totalNilaiKontrak = PaketPekerjaan::sum('nilai_total');
        $nilaiKontrakProgres = PaketPekerjaan::where('status', 'progres')->sum('nilai_total');
        $nilaiKontrakSelesai = PaketPekerjaan::where('status', 'selesai')->sum('nilai_total');

        // Statistik Master Data
        $totalOPD = OPD::count();
        $totalBadanUsaha = BadanUsaha::count();
        $totalTenagaAhli = TenagaAhli::count();
        $totalPekerjaan = Pekerjaan::count();

        // Paket Pekerjaan yang akan berakhir dalam 30 hari
        $paketBerakhir30Hari = PaketPekerjaan::where('status', 'progres')
            ->where('kontrak_selesai', '>=', now())
            ->where('kontrak_selesai', '<=', now()->addDays(30))
            ->count();

        // Paket Pekerjaan yang sudah melewati batas waktu
        $paketTerlambat = PaketPekerjaan::where('status', 'progres')
            ->where('kontrak_selesai', '<', now())
            ->count();

        // Top 5 OPD dengan paket terbanyak
        $topOPD = OPD::withCount(['paketPekerjaans' => function ($query) {
            $query->whereNull('deleted_at');
        }])
        ->orderBy('paket_pekerjaans_count', 'desc')
        ->take(5)
        ->get();

        // Paket Pekerjaan terbaru
        $paketTerbaru = PaketPekerjaan::with(['opd', 'badanUsaha'])
            ->orderBy('created_at', 'desc')
            ->take(5)
            ->get();

        // Statistik per bulan (6 bulan terakhir)
        $statistikBulanan = collect();
        for ($i = 5; $i >= 0; $i--) {
            $bulan = now()->subMonths($i);
            $jumlahPaket = PaketPekerjaan::whereYear('created_at', $bulan->year)
                ->whereMonth('created_at', $bulan->month)
                ->count();

            $statistikBulanan->push([
                'bulan' => $bulan->format('M Y'),
                'jumlah' => $jumlahPaket
            ]);
        }

        // Tenaga Ahli dengan SKK yang akan berakhir dalam 30 hari
        // $tenagaAhliSKKBerakhir = TenagaAhli::where('masa_berlaku_skk', '>=', now())
        //     ->where('masa_berlaku_skk', '<=', now()->addDays(30))
        //     ->count();

         $tenagaAhliSKKBerakhir = 0;

        return view('livewire.dashboard', [
            'totalPaket' => $totalPaket,
            'paketPerencanaan' => $paketPerencanaan,
            'paketTender' => $paketTender,
            'paketProgres' => $paketProgres,
            'paketSelesai' => $paketSelesai,
            'totalNilaiKontrak' => $totalNilaiKontrak,
            'nilaiKontrakProgres' => $nilaiKontrakProgres,
            'nilaiKontrakSelesai' => $nilaiKontrakSelesai,
            'totalOPD' => $totalOPD,
            'totalBadanUsaha' => $totalBadanUsaha,
            'totalTenagaAhli' => $totalTenagaAhli,
            'totalPekerjaan' => $totalPekerjaan,
            'paketBerakhir30Hari' => $paketBerakhir30Hari,
            'paketTerlambat' => $paketTerlambat,
            'topOPD' => $topOPD,
            'paketTerbaru' => $paketTerbaru,
            'statistikBulanan' => $statistikBulanan,
            'tenagaAhliSKKBerakhir' => $tenagaAhliSKKBerakhir,
        ]);
    }
}
