<?php

namespace App\Livewire\OPD;

use App\Models\OPD;
use Livewire\Component;
use Livewire\Attributes\On;
use Livewire\Attributes\Rule;

class Form extends Component
{
    public $showModal = false;

    #[Rule('required|min:3|max:255')]
    public $nama_opd = '';

    #[Rule('required|min:2|max:10|unique:opds,kode_opd')]
    public $kode_opd = '';

    #[Rule('nullable|max:500')]
    public $alamat_opd = '';

    #[Rule('nullable|email|max:255')]
    public $email_opd = '';

    #[Rule('nullable|max:20')]
    public $telepon_opd = '';

    #[Rule('nullable|max:255')]
    public $kepala_opd = '';

    #[Rule('nullable|max:20')]
    public $nip_kepala_opd = '';

    #[Rule('required|in:aktif,nonaktif')]
    public $status = 'aktif';

    public $editingId = null;

    #[On('form-show')]
    public function show($opdId = null)
    {
        $this->resetForm();
        $this->showModal = true;

        if ($opdId) {
            $this->editingId = $opdId;
            $this->loadData();
        }
    }

    public function loadData()
    {
        $opd = OPD::find($this->editingId);

        $this->nama_opd = $opd->nama_opd;
        $this->kode_opd = $opd->kode_opd;
        $this->alamat_opd = $opd->alamat_opd;
        $this->email_opd = $opd->email_opd;
        $this->telepon_opd = $opd->telepon_opd;
        $this->kepala_opd = $opd->kepala_opd;
        $this->nip_kepala_opd = $opd->nip_kepala_opd;
        $this->status = $opd->status;
    }

    public function save()
    {
        $this->validate();

        if ($this->editingId) {
            OPD::find($this->editingId)->update([
                'nama_opd' => $this->nama_opd,
                'kode_opd' => $this->kode_opd,
                'alamat_opd' => $this->alamat_opd,
                'email_opd' => $this->email_opd,
                'telepon_opd' => $this->telepon_opd,
                'kepala_opd' => $this->kepala_opd,
                'nip_kepala_opd' => $this->nip_kepala_opd,
                'status' => $this->status
            ]);
        } else {
            OPD::create([
                'nama_opd' => $this->nama_opd,
                'kode_opd' => $this->kode_opd,
                'alamat_opd' => $this->alamat_opd,
                'email_opd' => $this->email_opd,
                'telepon_opd' => $this->telepon_opd,
                'kepala_opd' => $this->kepala_opd,
                'nip_kepala_opd' => $this->nip_kepala_opd,
                'status' => $this->status
            ]);
        }

        $this->dispatch('item-saved');
        $this->closeModal();
    }

    public function resetForm()
    {
        $this->reset(['nama_opd', 'kode_opd', 'alamat_opd', 'email_opd', 'telepon_opd', 'kepala_opd', 'nip_kepala_opd', 'status', 'editingId']);
        $this->resetValidation();
    }

    public function closeModal()
    {
        $this->showModal = false;
        $this->resetForm();
        $this->resetValidation();
    }

    public function render()
    {
        return view('livewire.o-p-d.form', [
            'statusList' => OPD::STATUS_LIST
        ]);
    }
}
