<?php

namespace App\Livewire\PaketPekerjaan;

use App\Models\PaketPekerjaan;
use Livewire\Component;
use Livewire\Attributes\On;

class Detail extends Component
{
    public $showModal = false;
    public $paketPekerjaan = null;

    #[On('detail-show')]
    public function show($paketPekerjaanId)
    {
        $this->paketPekerjaan = PaketPekerjaan::with(['opd', 'badanUsaha', 'tenagaAhli', 'pekerjaans'])
            ->find($paketPekerjaanId);
        $this->showModal = true;
    }

    public function closeModal()
    {
        $this->showModal = false;
        $this->paketPekerjaan = null;
    }

    public function render()
    {
        return view('livewire.paket-pekerjaan.detail');
    }
}
