<?php

namespace App\Livewire;

use App\Models\BadanUsaha;
use Livewire\Attributes\Url;
use Livewire\Component;
use Livewire\WithPagination;

class PenyediaTable extends Component
{
    use WithPagination;

    #[Url(as: 'search')]
    public $search = '';

    #[Url(as: 'type')]
    public $searchType = 'NamaBadanUsaha';

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public function updatingSearchType()
    {
        $this->resetPage();
    }

    public function getResults()
    {
        $query = BadanUsaha::query()->with(['kbli2017', 'kbli2020', 'legalitas', 'pengurus', 'pjsk2017', 'pjsk2020']);

        if (!empty($this->search)) {
            if ($this->searchType === 'NPWP') {
                $query->where('npwp', 'LIKE', "%{$this->search}%");
            } else {
                $query->where('nama_badan_usaha', 'LIKE', "%{$this->search}%");
            }
        }

        return $query->paginate(10);
    }

    public function render()
    {
        return view('livewire.penyedia-table', [
            'badanUsaha' => $this->getResults()
        ]);
    }
}
