<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class BadanUsaha extends Model
{
    protected $table = 'badan_usaha';

    protected $fillable = [
        'nama_badan_usaha',
        'alamat_badan_usaha',
        'nomor_telepon',
        'email',
        'nib',
        'npwp',
        'penanggungjawab_badan_usaha',
        'penanggungjawab_teknik',
        'kabupaten'
    ];

    public function kbli2017(): HasMany
    {
        return $this->hasMany(Kbli2017::class);
    }

    public function kbli2020(): HasMany
    {
        return $this->hasMany(Kbli2020::class);
    }

    public function legalitas(): HasMany
    {
        return $this->hasMany(Legalitas::class);
    }

    public function pengurus(): HasMany
    {
        return $this->hasMany(Pengurus::class);
    }

    public function pjsk2017(): HasMany
    {
        return $this->hasMany(Pjsk2017::class);
    }

    public function pjsk2020(): HasMany
    {
        return $this->hasMany(Pjsk2020::class);
    }

    public function pekerjaans(): HasMany
    {
        return $this->hasMany(Pekerjaan::class, 'penyedia_id');
    }

    public function paketPekerjaans(): HasMany
    {
        return $this->hasMany(PaketPekerjaan::class);
    }
}
