<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Kbli2020 extends Model
{
    protected $table = 'kbli_2020';

    protected $fillable = [
        'badan_usaha_id',
        'id_izin',
        'subklasifikasi_layanan',
        'kode',
        'kualifikasi',
        'penerbit',
        'tanggal_terbit',
        'tanggal_habis',
        'status_terakhir'
    ];

    protected $casts = [
        'tanggal_terbit' => 'date',
        'tanggal_habis' => 'date'
    ];

    public function badanUsaha(): BelongsTo
    {
        return $this->belongsTo(BadanUsaha::class);
    }
}
