<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OPD extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'opds';

    protected $fillable = [
        'nama_opd',
        'kode_opd',
        'alamat_opd',
        'email_opd',
        'telepon_opd',
        'kepala_opd',
        'nip_kepala_opd',
        'status'
    ];

    protected $casts = [
        'status' => 'string'
    ];

    public const STATUS_LIST = [
        'aktif' => 'Aktif',
        'nonaktif' => 'Non Aktif'
    ];

    public function paketPekerjaans()
    {
        return $this->hasMany(PaketPekerjaan::class, 'opd_id');
    }
}
