<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Model;


class TenagaAhli extends Model
{
   
     protected $table = 'tk_tenaga_kerja';

    protected $fillable = [
        'nama',
        'alamat',
        'tanggal_simpan'
    ];

    // protected $casts = [
    //     'masa_berlaku_skk' => 'date'
    // ];

    public const KUALIFIKASI_LIST = [
        'KLASIFIKASI SIPIL',
        'KLASIFIKASI MEKANIKAL',
        'KLASIFIKASI TATA LINGKUNGAN',
        'KLASIFIKASI MANAJEMEN PELAKSANAAN',
        'KLASIFIKASI ARSITEKTUR LANSKAP, ILUMINASI DAN DESAIN INTERIOR',
        'KLASIFIKASI PERENCANAAN WILAYAH DAN KOTA',
        'KLASIFIKASI SAINS DAN REKAYASA TEKNIK'
    ];

    public function pekerjaans()
    {
        return $this->belongsToMany(Pekerjaan::class, 'pekerjaan_tenaga_ahli');
    }

    public function paketPekerjaans()
    {
        return $this->belongsToMany(PaketPekerjaan::class, 'paket_pekerjaan_tenaga_ahli');
    }

     public function tenaga_ska(): HasMany
    {
        return $this->hasMany(TenagaAhli_ska::class, 'tenaga_kerja_id');
    }
     public function tenaga_skk(): HasMany
    {
        return $this->hasMany(TenagaAhli_skk::class, 'tenaga_kerja_id');
    }
      public function tenaga_skt(): HasMany
    {
        return $this->hasMany(TenagaAhli_skt::class, 'tenaga_kerja_id');
    }
}
