

<div class="space-y-6">


    <!-- Statistik Utama -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
        <!-- Total Paket Pekerjaan -->
        <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
            <div class="flex items-center">
                <div class="p-3 rounded-full bg-blue-100 text-blue-600">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-600">Total Paket</p>
                    <p class="text-2xl font-bold text-gray-900">{{ number_format($totalPaket) }}</p>
                </div>
            </div>
        </div>

        <!-- Nilai Total Kontrak -->
        <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
            <div class="flex items-center">
                <div class="p-3 rounded-full bg-green-100 text-green-600">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                    </svg>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-600">Nilai Kontrak</p>
                    <p class="text-2xl font-bold text-gray-900">Rp {{ number_format($totalNilaiKontrak, 0, ',', '.') }}</p>
                </div>
            </div>
        </div>

        <!-- Paket Progres -->
        <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
            <div class="flex items-center">
                <div class="p-3 rounded-full bg-orange-100 text-orange-600">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                    </svg>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-600">Sedang Berjalan</p>
                    <p class="text-2xl font-bold text-gray-900">{{ number_format($paketProgres) }}</p>
                </div>
            </div>
        </div>

        <!-- Total OPD -->
        <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
            <div class="flex items-center">
                <div class="p-3 rounded-full bg-purple-100 text-purple-600">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                    </svg>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-600">Total OPD</p>
                    <p class="text-2xl font-bold text-gray-900">{{ number_format($totalOPD) }}</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Statistik Status Paket -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- Status Paket Pekerjaan -->
        <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">Status Paket Pekerjaan</h3>
            <div class="space-y-3">
                <div class="flex items-center justify-between">
                    <div class="flex items-center">
                        <div class="w-3 h-3 bg-blue-500 rounded-full mr-3"></div>
                        <span class="text-sm text-gray-600">Perencanaan</span>
                    </div>
                    <span class="text-sm font-semibold text-gray-900">{{ $paketPerencanaan }}</span>
                </div>
                <div class="flex items-center justify-between">
                    <div class="flex items-center">
                        <div class="w-3 h-3 bg-yellow-500 rounded-full mr-3"></div>
                        <span class="text-sm text-gray-600">Tender</span>
                    </div>
                    <span class="text-sm font-semibold text-gray-900">{{ $paketTender }}</span>
                </div>
                <div class="flex items-center justify-between">
                    <div class="flex items-center">
                        <div class="w-3 h-3 bg-orange-500 rounded-full mr-3"></div>
                        <span class="text-sm text-gray-600">Progres</span>
                    </div>
                    <span class="text-sm font-semibold text-gray-900">{{ $paketProgres }}</span>
                </div>
                <div class="flex items-center justify-between">
                    <div class="flex items-center">
                        <div class="w-3 h-3 bg-green-500 rounded-full mr-3"></div>
                        <span class="text-sm text-gray-600">Selesai</span>
                    </div>
                    <span class="text-sm font-semibold text-gray-900">{{ $paketSelesai }}</span>
                </div>
            </div>
        </div>

        <!-- Alert & Warning -->
        <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">Peringatan & Alert</h3>
            <div class="space-y-3">
                @if($paketBerakhir30Hari > 0)
                    <div class="flex items-center p-3 bg-yellow-50 border border-yellow-200 rounded-lg">
                        <div class="p-2 rounded-full bg-yellow-100 text-yellow-600 mr-3">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L3.732 16.5c-.77.833.192 2.5 1.732 2.5z"></path>
                            </svg>
                        </div>
                        <div>
                            <p class="text-sm font-medium text-yellow-800">{{ $paketBerakhir30Hari }} paket akan berakhir dalam 30 hari</p>
                        </div>
                    </div>
                @endif

                @if($paketTerlambat > 0)
                    <div class="flex items-center p-3 bg-red-50 border border-red-200 rounded-lg">
                        <div class="p-2 rounded-full bg-red-100 text-red-600 mr-3">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                        </div>
                        <div>
                            <p class="text-sm font-medium text-red-800">{{ $paketTerlambat }} paket sudah melewati batas waktu</p>
                        </div>
                    </div>
                @endif

                @if($tenagaAhliSKKBerakhir > 0)
                    <div class="flex items-center p-3 bg-orange-50 border border-orange-200 rounded-lg">
                        <div class="p-2 rounded-full bg-orange-100 text-orange-600 mr-3">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                            </svg>
                        </div>
                        <div>
                            <p class="text-sm font-medium text-orange-800">{{ $tenagaAhliSKKBerakhir }} tenaga ahli SKK akan berakhir dalam 30 hari</p>
                        </div>
                    </div>
                @endif

                @if($paketBerakhir30Hari == 0 && $paketTerlambat == 0 && $tenagaAhliSKKBerakhir == 0)
                    <div class="flex items-center p-3 bg-green-50 border border-green-200 rounded-lg">
                        <div class="p-2 rounded-full bg-green-100 text-green-600 mr-3">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                        </div>
                        <div>
                            <p class="text-sm font-medium text-green-800">Semua data dalam kondisi baik</p>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>

    <!-- Statistik Detail -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Master Data -->
        <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">Master Data</h3>
            <div class="space-y-3">
                <div class="flex items-center justify-between">
                    <span class="text-sm text-gray-600">OPD</span>
                    <span class="text-sm font-semibold text-gray-900">{{ $totalOPD }}</span>
                </div>
                <div class="flex items-center justify-between">
                    <span class="text-sm text-gray-600">Badan Usaha</span>
                    <span class="text-sm font-semibold text-gray-900">{{ $totalBadanUsaha }}</span>
                </div>
                <div class="flex items-center justify-between">
                    <span class="text-sm text-gray-600">Tenaga Ahli</span>
                    <span class="text-sm font-semibold text-gray-900">{{ $totalTenagaAhli }}</span>
                </div>
                <div class="flex items-center justify-between">
                    <span class="text-sm text-gray-600">Pekerjaan</span>
                    <span class="text-sm font-semibold text-gray-900">{{ $totalPekerjaan }}</span>
                </div>
            </div>
        </div>

        <!-- Nilai Kontrak -->
        <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">Nilai Kontrak</h3>
            <div class="space-y-3">
                <div class="flex items-center justify-between">
                    <span class="text-sm text-gray-600">Total</span>
                    <span class="text-sm font-semibold text-gray-900">Rp {{ number_format($totalNilaiKontrak, 0, ',', '.') }}</span>
                </div>
                <div class="flex items-center justify-between">
                    <span class="text-sm text-gray-600">Sedang Berjalan</span>
                    <span class="text-sm font-semibold text-gray-900">Rp {{ number_format($nilaiKontrakProgres, 0, ',', '.') }}</span>
                </div>
                <div class="flex items-center justify-between">
                    <span class="text-sm text-gray-600">Selesai</span>
                    <span class="text-sm font-semibold text-gray-900">Rp {{ number_format($nilaiKontrakSelesai, 0, ',', '.') }}</span>
                </div>
            </div>
        </div>

        <!-- Top OPD -->
        <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">Top 5 OPD</h3>
            <div class="space-y-3">
                @forelse($topOPD as $opd)
                    <div class="flex items-center justify-between">
                        <span class="text-sm text-gray-600 truncate">{{ $opd->nama_opd }}</span>
                        <span class="text-sm font-semibold text-gray-900">{{ $opd->paket_pekerjaans_count }}</span>
                    </div>
                @empty
                    <p class="text-sm text-gray-500">Belum ada data OPD</p>
                @endforelse
            </div>
        </div>
    </div>

    <!-- Paket Terbaru -->
    <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
        <h3 class="text-lg font-semibold text-gray-900 mb-4">Paket Pekerjaan Terbaru</h3>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Kode</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Nama Paket</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">OPD</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Nilai</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Tanggal</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($paketTerbaru as $paket)
                        <tr>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">{{ $paket->kode_paket }}</td>
                            <td class="px-6 py-4 text-sm text-gray-900 max-w-xs truncate" title="{{ $paket->nama_paket }}">{{ $paket->nama_paket }}</td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ $paket->opd->nama_opd ?? '-' }}</td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                @php
                                    $statusColors = [
                                        'perencanaan' => 'bg-blue-100 text-blue-800',
                                        'tender' => 'bg-yellow-100 text-yellow-800',
                                        'progres' => 'bg-orange-100 text-orange-800',
                                        'selesai' => 'bg-green-100 text-green-800'
                                    ];
                                    $statusColor = $statusColors[$paket->status] ?? 'bg-gray-100 text-gray-800';
                                @endphp
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium {{ $statusColor }}">
                                    {{ ucfirst($paket->status) }}
                                </span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                @if($paket->nilai_total)
                                    Rp {{ number_format($paket->nilai_total, 0, ',', '.') }}
                                @else
                                    -
                                @endif
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ $paket->created_at->format('d/m/Y') }}</td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="px-6 py-4 text-center text-sm text-gray-500">
                                Belum ada data paket pekerjaan
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
