<div>
    @if($showModal)
    <div class="relative z-10" aria-labelledby="modal-title" role="dialog" aria-modal="true">
        <div class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity"></div>

        <div class="fixed inset-0 z-10 w-screen overflow-y-auto">
            <div class="flex min-h-full items-end justify-center p-4 text-center sm:items-center sm:p-0">
                <div class="relative transform overflow-hidden rounded-lg bg-white px-4 pb-4 pt-5 text-left shadow-xl transition-all sm:my-8 sm:w-full sm:max-w-2xl sm:p-6">
                    <div class="absolute right-0 top-0 hidden pr-4 pt-4 sm:block">
                        <button wire:click="closeModal" type="button" class="rounded-md bg-white text-gray-400 hover:text-gray-500">
                            <span class="sr-only">Close</span>
                            <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" />
                            </svg>
                        </button>
                    </div>

                    <div class="sm:flex sm:items-start">
                        <div class="mt-3 text-center sm:ml-4 sm:mt-0 sm:text-left w-full">
                            <h3 class="text-base font-semibold leading-6 text-text-primary" id="modal-title">
                                {{ $editingId ? 'Edit' : 'Tambah' }} OPD
                            </h3>

                            <form wire:submit.prevent="save" class="mt-4 space-y-4">
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    <!-- Nama OPD -->
                                    <div>
                                        <label for="nama_opd" class="block text-sm font-medium text-text-primary">
                                            Nama OPD <span class="text-red-500">*</span>
                                        </label>
                                        <div class="mt-1">
                                            <input
                                                type="text"
                                                wire:model="nama_opd"
                                                id="nama_opd"
                                                placeholder="Masukkan nama OPD"
                                                class="block w-full rounded-md border-0 py-1.5 text-text-primary shadow-sm ring-1 ring-inset ring-gray-300 placeholder:text-gray-400 focus:ring-2 focus:ring-inset focus:ring-primary-600 sm:text-sm sm:leading-6"
                                            >
                                        </div>
                                        @error('nama_opd')
                                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                        @enderror
                                    </div>

                                    <!-- Kode OPD -->
                                    <div>
                                        <label for="kode_opd" class="block text-sm font-medium text-text-primary">
                                            Kode OPD <span class="text-red-500">*</span>
                                        </label>
                                        <div class="mt-1">
                                            <input
                                                type="text"
                                                wire:model="kode_opd"
                                                id="kode_opd"
                                                placeholder="Contoh: 1.01"
                                                class="block w-full rounded-md border-0 py-1.5 text-text-primary shadow-sm ring-1 ring-inset ring-gray-300 placeholder:text-gray-400 focus:ring-2 focus:ring-inset focus:ring-primary-600 sm:text-sm sm:leading-6"
                                            >
                                        </div>
                                        @error('kode_opd')
                                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                        @enderror
                                    </div>
                                </div>

                                <!-- Alamat OPD -->
                                <div>
                                    <label for="alamat_opd" class="block text-sm font-medium text-text-primary">
                                        Alamat OPD
                                    </label>
                                    <div class="mt-1">
                                        <textarea
                                            wire:model="alamat_opd"
                                            id="alamat_opd"
                                            rows="3"
                                            placeholder="Masukkan alamat lengkap OPD"
                                            class="block w-full rounded-md border-0 py-1.5 text-text-primary shadow-sm ring-1 ring-inset ring-gray-300 placeholder:text-gray-400 focus:ring-2 focus:ring-inset focus:ring-primary-600 sm:text-sm sm:leading-6"
                                        ></textarea>
                                    </div>
                                    @error('alamat_opd')
                                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    <!-- Email OPD -->
                                    <div>
                                        <label for="email_opd" class="block text-sm font-medium text-text-primary">
                                            Email OPD
                                        </label>
                                        <div class="mt-1">
                                            <input
                                                type="email"
                                                wire:model="email_opd"
                                                id="email_opd"
                                                placeholder="email@opd.go.id"
                                                class="block w-full rounded-md border-0 py-1.5 text-text-primary shadow-sm ring-1 ring-inset ring-gray-300 placeholder:text-gray-400 focus:ring-2 focus:ring-inset focus:ring-primary-600 sm:text-sm sm:leading-6"
                                            >
                                        </div>
                                        @error('email_opd')
                                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                        @enderror
                                    </div>

                                    <!-- Telepon OPD -->
                                    <div>
                                        <label for="telepon_opd" class="block text-sm font-medium text-text-primary">
                                            Telepon OPD
                                        </label>
                                        <div class="mt-1">
                                            <input
                                                type="text"
                                                wire:model="telepon_opd"
                                                id="telepon_opd"
                                                placeholder="021-1234567"
                                                class="block w-full rounded-md border-0 py-1.5 text-text-primary shadow-sm ring-1 ring-inset ring-gray-300 placeholder:text-gray-400 focus:ring-2 focus:ring-inset focus:ring-primary-600 sm:text-sm sm:leading-6"
                                            >
                                        </div>
                                        @error('telepon_opd')
                                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                        @enderror
                                    </div>
                                </div>

                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    <!-- Kepala OPD -->
                                    <div>
                                        <label for="kepala_opd" class="block text-sm font-medium text-text-primary">
                                            Kepala OPD
                                        </label>
                                        <div class="mt-1">
                                            <input
                                                type="text"
                                                wire:model="kepala_opd"
                                                id="kepala_opd"
                                                placeholder="Nama Kepala OPD"
                                                class="block w-full rounded-md border-0 py-1.5 text-text-primary shadow-sm ring-1 ring-inset ring-gray-300 placeholder:text-gray-400 focus:ring-2 focus:ring-inset focus:ring-primary-600 sm:text-sm sm:leading-6"
                                            >
                                        </div>
                                        @error('kepala_opd')
                                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                        @enderror
                                    </div>

                                    <!-- NIP Kepala OPD -->
                                    <div>
                                        <label for="nip_kepala_opd" class="block text-sm font-medium text-text-primary">
                                            NIP Kepala OPD
                                        </label>
                                        <div class="mt-1">
                                            <input
                                                type="text"
                                                wire:model="nip_kepala_opd"
                                                id="nip_kepala_opd"
                                                placeholder="198501012010011001"
                                                class="block w-full rounded-md border-0 py-1.5 text-text-primary shadow-sm ring-1 ring-inset ring-gray-300 placeholder:text-gray-400 focus:ring-2 focus:ring-inset focus:ring-primary-600 sm:text-sm sm:leading-6"
                                            >
                                        </div>
                                        @error('nip_kepala_opd')
                                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                        @enderror
                                    </div>
                                </div>

                                <!-- Status -->
                                <div>
                                    <label for="status" class="block text-sm font-medium text-text-primary">
                                        Status <span class="text-red-500">*</span>
                                    </label>
                                    <div class="mt-1">
                                        <select
                                            wire:model="status"
                                            id="status"
                                            class="block w-full rounded-md border-0 py-1.5 text-text-primary shadow-sm ring-1 ring-inset ring-gray-300 focus:ring-2 focus:ring-inset focus:ring-primary-600 sm:text-sm sm:leading-6"
                                        >
                                            @foreach($statusList as $value => $label)
                                                <option value="{{ $value }}">{{ $label }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    @error('status')
                                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div class="mt-5 sm:mt-4 sm:flex sm:flex-row-reverse">
                                    <button
                                        type="submit"
                                        wire:loading.attr="disabled"
                                        class="inline-flex w-full justify-center rounded-md bg-primary-600 px-3 py-2 text-sm font-semibold text-white shadow-sm hover:bg-primary-500 disabled:opacity-50 sm:ml-3 sm:w-auto"
                                    >
                                        <span wire:loading.remove>{{ $editingId ? 'Update' : 'Simpan' }}</span>
                                        <span wire:loading>Menyimpan...</span>
                                    </button>
                                    <button
                                        wire:click="closeModal"
                                        type="button"
                                        class="mt-3 inline-flex w-full justify-center rounded-md bg-white px-3 py-2 text-sm font-semibold text-text-primary shadow-sm ring-1 ring-inset ring-gray-300 hover:bg-gray-50 sm:mt-0 sm:w-auto"
                                    >
                                        Batal
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif
</div>
