<div class="space-y-6">
    <!-- Search Section -->
    <div class="bg-surface rounded-lg shadow-sm border border-gray-200 p-6">
        <h3 class="font-heading text-lg font-medium text-text-primary mb-4">Pencarian OPD</h3>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <!-- Search Input -->
            <div>
                <label for="search" class="block text-sm font-medium text-text-primary mb-2">
                    Parameter Pencarian
                </label>
                <input
                    type="text"
                    id="search"
                    wire:model.live.debounce.300ms="search"
                    placeholder="Masukkan nama OPD, kode, atau kepala OPD..."
                    class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:ring-primary-500 focus:border-primary-500 bg-surface text-text-primary"
                >
            </div>

            <!-- Add Button -->
            <div class="flex items-end">
                <button  style="background: blue;"
                    wire:click="createNew"
                    type="button"
                    wire:loading.attr="disabled"
                    class="w-full md:w-auto px-4 py-2 bg-primary-600 text-white rounded-md hover:bg-primary-700 disabled:opacity-50 transition-colors duration-150"
                >
                    <span wire:loading.remove class="flex items-center">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                        </svg>
                        Tambah OPD
                    </span>
                    <span wire:loading class="flex items-center">
                        <svg class="animate-spin -ml-1 mr-3 h-4 w-4 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                            <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                        </svg>
                        Loading...
                    </span>
                </button>
            </div>
        </div>

        @if($search)
            <div class="mt-4 flex items-center text-sm text-text-secondary">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                </svg>
                Mencari "{{ $search }}"
            </div>
        @endif
    </div>

    <!-- Results Section -->
    <div class="bg-surface rounded-lg shadow-sm border border-gray-200">
        <div class="px-6 py-4 border-b border-gray-200">
            <div class="flex items-center justify-between">
                <h3 class="font-heading text-lg font-medium text-text-primary">
                    Daftar OPD
                </h3>
                <div class="text-sm text-text-secondary">
                    Total: {{ $opd->total() }} data
                </div>
            </div>
        </div>

        <!-- Loading State -->
        <div wire:loading.delay class="p-6">
            <div class="flex items-center justify-center space-x-2">
                <div class="animate-spin rounded-full h-5 w-5 border-b-2 border-primary-800"></div>
                <span class="text-text-secondary">Mencari data...</span>
            </div>
        </div>

        <!-- Table -->
        <div class="overflow-x-auto" wire:loading.remove.delay>
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-text-secondary uppercase tracking-wider">No</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-text-secondary uppercase tracking-wider">Kode OPD</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-text-secondary uppercase tracking-wider">Nama OPD</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-text-secondary uppercase tracking-wider">Kepala OPD</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-text-secondary uppercase tracking-wider">Kontak</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-text-secondary uppercase tracking-wider">Status</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-text-secondary uppercase tracking-wider">Aksi</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($opd as $index => $item)
                    <tr class="hover:bg-gray-50 transition-colors duration-150">
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-text-primary">
                            {{ $opd->firstItem() + $index }}
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-text-primary">
                            {{ $item->kode_opd }}
                        </td>
                        <td class="px-6 py-4 text-sm font-medium text-text-primary">
                            <div class="max-w-xs truncate" title="{{ $item->nama_opd }}">
                                {{ $item->nama_opd }}
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-text-primary">
                            <div class="max-w-xs truncate" title="{{ $item->kepala_opd }}">
                                {{ $item->kepala_opd ?? '-' }}
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-text-primary">
                            <div class="space-y-1">
                                @if($item->email_opd)
                                    <div class="text-xs text-text-secondary">{{ $item->email_opd }}</div>
                                @endif
                                @if($item->telepon_opd)
                                    <div class="text-xs text-text-secondary">{{ $item->telepon_opd }}</div>
                                @endif
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-text-primary">
                            @if($item->status === 'aktif')
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                    Aktif
                                </span>
                            @else
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-100 text-red-800">
                                    Non Aktif
                                </span>
                            @endif
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                            <button
                                wire:click="edit({{ $item->id }})"
                                class="inline-flex items-center px-3 py-1 border border-transparent text-sm leading-4 font-medium rounded-md text-primary-600 hover:text-primary-900 hover:bg-primary-50 transition-colors duration-150 mr-2"
                            >
                                <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                                </svg>
                                Edit
                            </button>
                            <button
                                wire:click="delete({{ $item->id }})"
                                wire:confirm="Apakah Anda yakin ingin menghapus data ini?"
                                class="inline-flex items-center px-3 py-1 border border-transparent text-sm leading-4 font-medium rounded-md text-red-600 hover:text-red-900 hover:bg-red-50 transition-colors duration-150"
                            >
                                <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                                </svg>
                                Hapus
                            </button>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="7" class="px-6 py-8 text-center">
                            <div class="flex flex-col items-center space-y-2">
                                <svg class="w-12 h-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                                </svg>
                                <p class="text-text-secondary">
                                    @if($search)
                                        Tidak ada data yang ditemukan untuk pencarian "{{ $search }}"
                                    @else
                                        Belum ada data OPD
                                    @endif
                                </p>
                            </div>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        @if($opd->hasPages())
        <div class="px-6 py-4 border-t border-gray-200">
            {{ $opd->links() }}
        </div>
        @endif
    </div>

    <!-- Form Modal -->
    <livewire:o-p-d.form />

    <!-- Notification -->
    <div x-data="{ show: false, title: '', message: '', type: 'success' }"
         x-show="show"
         x-on:notify.window="show = true; title = $event.detail.title; message = $event.detail.message; type = $event.detail.type || 'success'; setTimeout(() => show = false, 3000)"
         class="fixed top-4 right-4 z-50">
        <div x-show="type === 'success'" class="bg-green-500 text-white px-6 py-3 rounded-lg shadow-lg">
            <div class="font-semibold" x-text="title"></div>
            <div class="text-sm" x-text="message"></div>
        </div>
        <div x-show="type === 'error'" class="bg-red-500 text-white px-6 py-3 rounded-lg shadow-lg">
            <div class="font-semibold" x-text="title"></div>
            <div class="text-sm" x-text="message"></div>
        </div>
    </div>
</div>
