<div>
    @if($showModal && $paketPekerjaan)
        <div class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50" id="detail-modal">
            <div class="relative top-20 mx-auto p-5 border w-11/12 md:w-3/4 lg:w-2/3 shadow-lg rounded-md bg-white">
                <div class="mt-3">
                    <div class="flex justify-between items-center mb-6">
                        <h3 class="text-xl font-semibold text-text-primary">
                            Detail Paket Pekerjaan
                        </h3>
                        <button wire:click="closeModal" class="text-gray-400 hover:text-gray-600">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                            </svg>
                        </button>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- Informasi Dasar -->
                        <div class="space-y-4">
                            <div>
                                <h4 class="text-lg font-medium text-text-primary mb-3">Informasi Dasar</h4>
                                <div class="bg-gray-50 p-4 rounded-lg space-y-3">
                                    <div>
                                        <span class="text-sm font-medium text-text-secondary">Kode Paket:</span>
                                        <p class="text-text-primary font-semibold">{{ $paketPekerjaan->kode_paket }}</p>
                                    </div>
                                    <div>
                                        <span class="text-sm font-medium text-text-secondary">Nama Paket:</span>
                                        <p class="text-text-primary">{{ $paketPekerjaan->nama_paket }}</p>
                                    </div>
                                    <div>
                                        <span class="text-sm font-medium text-text-secondary">Status:</span>
                                        @php
                                            $statusColors = [
                                                'perencanaan' => 'bg-blue-100 text-blue-800',
                                                'tender' => 'bg-yellow-100 text-yellow-800',
                                                'progres' => 'bg-orange-100 text-orange-800',
                                                'selesai' => 'bg-green-100 text-green-800'
                                            ];
                                            $statusColor = $statusColors[$paketPekerjaan->status] ?? 'bg-gray-100 text-gray-800';
                                        @endphp
                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium {{ $statusColor }} mt-1">
                                            {{ \App\Models\PaketPekerjaan::STATUS_LIST[$paketPekerjaan->status] ?? $paketPekerjaan->status }}
                                        </span>
                                    </div>
                                    <div>
                                        <span class="text-sm font-medium text-text-secondary">Nilai Total:</span>
                                        <p class="text-text-primary">
                                            @if($paketPekerjaan->nilai_total)
                                                Rp {{ number_format($paketPekerjaan->nilai_total, 0, ',', '.') }}
                                            @else
                                                <span class="text-text-secondary">-</span>
                                            @endif
                                        </p>
                                    </div>
                                </div>
                            </div>

                            <!-- Informasi Kontrak -->
                            <div>
                                <h4 class="text-lg font-medium text-text-primary mb-3">Informasi Kontrak</h4>
                                <div class="bg-gray-50 p-4 rounded-lg space-y-3">
                                    <div>
                                        <span class="text-sm font-medium text-text-secondary">Tanggal Mulai:</span>
                                        <p class="text-text-primary">
                                            {{ $paketPekerjaan->kontrak_mulai ? $paketPekerjaan->kontrak_mulai->format('d/m/Y') : '-' }}
                                        </p>
                                    </div>
                                    <div>
                                        <span class="text-sm font-medium text-text-secondary">Tanggal Selesai:</span>
                                        <p class="text-text-primary">
                                            {{ $paketPekerjaan->kontrak_selesai ? $paketPekerjaan->kontrak_selesai->format('d/m/Y') : '-' }}
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Informasi OPD dan Badan Usaha -->
                        <div class="space-y-4">
                            <!-- OPD -->
                            <div>
                                <h4 class="text-lg font-medium text-text-primary mb-3">OPD</h4>
                                <div class="bg-gray-50 p-4 rounded-lg space-y-3">
                                    @if($paketPekerjaan->opd)
                                        <div>
                                            <span class="text-sm font-medium text-text-secondary">Nama OPD:</span>
                                            <p class="text-text-primary font-semibold">{{ $paketPekerjaan->opd->nama_opd }}</p>
                                        </div>
                                        <div>
                                            <span class="text-sm font-medium text-text-secondary">Kode OPD:</span>
                                            <p class="text-text-primary">{{ $paketPekerjaan->opd->kode_opd }}</p>
                                        </div>
                                        <div>
                                            <span class="text-sm font-medium text-text-secondary">Alamat:</span>
                                            <p class="text-text-primary">{{ $paketPekerjaan->opd->alamat_opd }}</p>
                                        </div>
                                        <div>
                                            <span class="text-sm font-medium text-text-secondary">Kepala OPD:</span>
                                            <p class="text-text-primary">{{ $paketPekerjaan->opd->kepala_opd }}</p>
                                        </div>
                                    @else
                                        <p class="text-text-secondary">Data OPD tidak tersedia</p>
                                    @endif
                                </div>
                            </div>

                            <!-- Badan Usaha -->
                            <div>
                                <h4 class="text-lg font-medium text-text-primary mb-3">Badan Usaha</h4>
                                <div class="bg-gray-50 p-4 rounded-lg space-y-3">
                                    @if($paketPekerjaan->badanUsaha)
                                        <div>
                                            <span class="text-sm font-medium text-text-secondary">Nama Badan Usaha:</span>
                                            <p class="text-text-primary font-semibold">{{ $paketPekerjaan->badanUsaha->nama_badan_usaha }}</p>
                                        </div>
                                        <div>
                                            <span class="text-sm font-medium text-text-secondary">NIB:</span>
                                            <p class="text-text-primary">{{ $paketPekerjaan->badanUsaha->nib }}</p>
                                        </div>
                                        <div>
                                            <span class="text-sm font-medium text-text-secondary">NPWP:</span>
                                            <p class="text-text-primary">{{ $paketPekerjaan->badanUsaha->npwp }}</p>
                                        </div>
                                        <div>
                                            <span class="text-sm font-medium text-text-secondary">Penanggung Jawab:</span>
                                            <p class="text-text-primary">{{ $paketPekerjaan->badanUsaha->penanggungjawab_badan_usaha }}</p>
                                        </div>
                                    @else
                                        <p class="text-text-secondary">Data Badan Usaha tidak tersedia</p>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Tenaga Ahli -->
                    <div class="mt-6">
                        <h4 class="text-lg font-medium text-text-primary mb-3">Tenaga Ahli ({{ $paketPekerjaan->tenagaAhli->count() }})</h4>
                        @if($paketPekerjaan->tenagaAhli->count() > 0)
                            <div class="bg-gray-50 p-4 rounded-lg">
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    @foreach($paketPekerjaan->tenagaAhli as $tenagaAhli)
                                        <div class="bg-white p-3 rounded border">
                                            <div class="font-medium text-text-primary">{{ $tenagaAhli->nama_tenaga_ahli }}</div>
                                            <div class="text-sm text-text-secondary">{{ $tenagaAhli->kualifikasi_skk }}</div>
                                            <div class="text-xs text-text-secondary mt-1">
                                                SKK berlaku: {{ $tenagaAhli->masa_berlaku_skk ? $tenagaAhli->masa_berlaku_skk->format('d/m/Y') : '-' }}
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        @else
                            <div class="bg-gray-50 p-4 rounded-lg">
                                <p class="text-text-secondary">Tidak ada tenaga ahli yang ditugaskan</p>
                            </div>
                        @endif
                    </div>

                    <!-- Pekerjaan -->
                    <div class="mt-6">
                        <h4 class="text-lg font-medium text-text-primary mb-3">Pekerjaan ({{ $paketPekerjaan->pekerjaans->count() }})</h4>
                        @if($paketPekerjaan->pekerjaans->count() > 0)
                            <div class="bg-gray-50 p-4 rounded-lg">
                                <div class="space-y-3">
                                    @foreach($paketPekerjaan->pekerjaans as $pekerjaan)
                                        <div class="bg-white p-3 rounded border">
                                            <div class="font-medium text-text-primary">{{ $pekerjaan->nama }}</div>
                                            <div class="text-sm text-text-secondary">{{ $pekerjaan->deskripsi }}</div>
                                            <div class="text-xs text-text-secondary mt-1">
                                                Lokasi: {{ $pekerjaan->lokasi }}
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        @else
                            <div class="bg-gray-50 p-4 rounded-lg">
                                <p class="text-text-secondary">Tidak ada pekerjaan yang terdaftar</p>
                            </div>
                        @endif
                    </div>

                    <div class="flex justify-end mt-6">
                        <button
                            type="button"
                            wire:click="closeModal"
                            class="px-4 py-2 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary-500"
                        >
                            Tutup
                        </button>
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>
