<div class="bg-surface rounded-lg shadow-sm border border-gray-200 p-6">
    <h3 class="font-heading text-lg font-medium text-text-primary mb-4">Pencarian Paket Pekerjaan</h3>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
        <!-- Search Input -->
        <div>
            <label for="search" class="block text-sm font-medium text-text-primary mb-2">Cari Paket Pekerjaan</label>
            <input
                type="text"
                id="search"
                wire:model.live.debounce.300ms="search"
                placeholder="Cari berdasarkan nama atau kode paket..."
                class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-primary-500 focus:border-primary-500"
            >
        </div>

        <!-- Add Button -->
        <div class="flex items-end">
            <button
                wire:click="createNew"
                class="inline-flex items-center px-4 py-2 bg-primary-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-primary-700 focus:bg-primary-700 " style="background: blue;"
            >
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                </svg>
                Tambah Paket Pekerjaan
            </button>
        </div>
    </div>

    @if($search)
        <div class="mt-4 flex items-center text-sm text-text-secondary">
            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
            </svg>
            Menampilkan hasil pencarian untuk: "{{ $search }}"
        </div>
    @endif

    <!-- Table -->
    <div class="mt-6 overflow-x-auto">
        <div class="inline-block min-w-full align-middle">
            <div class="overflow-hidden shadow ring-1 ring-black ring-opacity-5 md:rounded-lg">
                <table class="min-w-full divide-y divide-gray-300">
                    <thead class="bg-gray-50">
                        <tr>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Kode Paket</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Nama Paket</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">OPD</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Badan Usaha</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Nilai Total</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Tenaga Ahli</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Jumlah Pekerjaan</th>
                            <th scope="col" class="relative px-6 py-3">
                                <span class="sr-only">Aksi</span>
                            </th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @forelse($paketPekerjaans as $paket)
                            <tr>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm font-medium text-text-primary">{{ $paket->kode_paket }}</div>
                                </td>
                                <td class="px-6 py-4">
                                    <div class="text-sm text-text-primary max-w-xs truncate" title="{{ $paket->nama_paket }}">{{ $paket->nama_paket }}</div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm text-text-primary">
                                        {{ $paket->opd->nama_opd ?? '-' }}
                                        @if($paket->opd)
                                            <div class="text-xs text-text-secondary">{{ $paket->opd->kode_opd }}</div>
                                        @endif
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm text-text-primary max-w-xs truncate" title="{{ $paket->badanUsaha->nama_badan_usaha ?? '-' }}">{{ $paket->badanUsaha->nama_badan_usaha ?? '-' }}</div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    @if($paket->nilai_total)
                                        <div class="text-sm text-text-primary">Rp {{ number_format($paket->nilai_total, 0, ',', '.') }}</div>
                                    @else
                                        <span class="text-sm text-text-secondary">-</span>
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    @php
                                        $statusColors = [
                                            'perencanaan' => 'bg-blue-100 text-blue-800',
                                            'tender' => 'bg-yellow-100 text-yellow-800',
                                            'progres' => 'bg-orange-100 text-orange-800',
                                            'selesai' => 'bg-green-100 text-green-800'
                                        ];
                                        $statusColor = $statusColors[$paket->status] ?? 'bg-gray-100 text-gray-800';
                                    @endphp
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium {{ $statusColor }}">
                                        {{ $statusList[$paket->status] ?? $paket->status }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm text-text-primary">{{ $paket->tenagaAhli->count() }} tenaga ahli</div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm text-text-primary">{{ $paket->pekerjaans->count() }} pekerjaan</div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                    <div class="flex flex-col space-y-1">
                                        <button
                                            wire:click="showDetail({{ $paket->id }})"
                                            class="inline-flex items-center px-2 py-1 border border-transparent text-xs leading-3 font-medium rounded-md text-blue-600 hover:text-blue-900 hover:bg-blue-50 transition-colors duration-150"
                                        >
                                            Detail
                                        </button>
                                        <button
                                            wire:click="edit({{ $paket->id }})"
                                            class="inline-flex items-center px-2 py-1 border border-transparent text-xs leading-3 font-medium rounded-md text-primary-600 hover:text-primary-900 hover:bg-primary-50 transition-colors duration-150"
                                        >
                                            Edit
                                        </button>
                                        <button
                                            wire:click="delete({{ $paket->id }})"
                                            wire:confirm="Apakah Anda yakin ingin menghapus data ini?"
                                            class="inline-flex items-center px-2 py-1 border border-transparent text-xs leading-3 font-medium rounded-md text-red-600 hover:text-red-900 hover:bg-red-50 transition-colors duration-150"
                                        >
                                            Hapus
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="9" class="px-6 py-4 text-center text-sm text-text-secondary">
                                    Tidak ada data paket pekerjaan ditemukan.
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Pagination -->
    <div class="mt-6">
        {{ $paketPekerjaans->links() }}
    </div>
</div>
