<div class="bg-surface rounded-lg shadow-sm border border-gray-200 p-6">
    <h3 class="font-heading text-lg font-medium text-text-primary mb-4">Pencarian Pekerjaan</h3>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
        <!-- Search Input -->
        <div>
            <label for="search" class="block text-sm font-medium text-text-primary mb-2">Cari Pekerjaan</label>
            <input
                type="text"
                id="search"
                wire:model.live.debounce.300ms="search"
                placeholder="Cari berdasarkan nama pekerjaan atau penyedia..."
                class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-primary-500 focus:border-primary-500"
            >
        </div>

        <!-- Add Button -->
        <div class="flex items-end">
            <button
                wire:click="createNew"
                class="inline-flex items-center px-4 py-2 bg-primary-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-primary-700 focus:bg-primary-700 active:bg-primary-900 focus:outline-none focus:ring-2 focus:ring-primary-500 focus:ring-offset-2 transition ease-in-out duration-150"
            >
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                </svg>
                Tambah Pekerjaan
            </button>
        </div>
    </div>

    @if($search)
        <div class="mt-4 flex items-center text-sm text-text-secondary">
            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
            </svg>
            Menampilkan hasil pencarian untuk: "{{ $search }}"
        </div>
    @endif

    <!-- Table -->
    <div class="mt-6 overflow-hidden shadow ring-1 ring-black ring-opacity-5 md:rounded-lg">
        <table class="min-w-full divide-y divide-gray-300">
            <thead class="bg-gray-50">
                <tr>
                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Nama Pekerjaan</th>
                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Penyedia</th>
                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Tanggal</th>
                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Paket</th>
                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Tenaga Ahli</th>
                    <th scope="col" class="relative px-6 py-3">
                        <span class="sr-only">Aksi</span>
                    </th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                @forelse($pekerjaans as $pekerjaan)
                    <tr>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-sm font-medium text-text-primary">{{ $pekerjaan->nama }}</div>
                            @if($pekerjaan->lokasi)
                                <div class="text-sm text-text-secondary">{{ $pekerjaan->lokasi }}</div>
                            @endif
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-sm text-text-primary">{{ $pekerjaan->penyedia->nama_badan_usaha }}</div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-sm text-text-primary">
                                {{ $pekerjaan->tanggal_mulai->format('d/m/Y') }} - {{ $pekerjaan->tanggal_selesai->format('d/m/Y') }}
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            @if($pekerjaan->paketPekerjaan)
                                <div class="text-sm text-text-primary">{{ $pekerjaan->paketPekerjaan->nama_paket }}</div>
                                <div class="text-sm text-text-secondary">{{ $pekerjaan->paketPekerjaan->kode_paket }}</div>
                            @else
                                <span class="text-sm text-text-secondary">-</span>
                            @endif
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-sm text-text-primary">
                                {{ $pekerjaan->tenagaAhli->count() }} tenaga ahli
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                            <button
                                wire:click="edit({{ $pekerjaan->id }})"
                                class="inline-flex items-center px-3 py-1 border border-transparent text-sm leading-4 font-medium rounded-md text-primary-600 hover:text-primary-900 hover:bg-primary-50 transition-colors duration-150 mr-2"
                            >
                                Edit
                            </button>
                            <button
                                wire:click="delete({{ $pekerjaan->id }})"
                                wire:confirm="Apakah Anda yakin ingin menghapus data ini?"
                                class="inline-flex items-center px-3 py-1 border border-transparent text-sm leading-4 font-medium rounded-md text-red-600 hover:text-red-900 hover:bg-red-50 transition-colors duration-150"
                            >
                                Hapus
                            </button>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="6" class="px-6 py-4 text-center text-sm text-text-secondary">
                            Tidak ada data pekerjaan ditemukan.
                        </td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <div class="mt-6">
        {{ $pekerjaans->links() }}
    </div>
</div>
