<div>
    @if($showModal && $badanUsaha)
    <div class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50" wire:click="closeModal">
        <div class="relative top-20 mx-auto p-5 border w-11/12 md:w-3/4 shadow-lg rounded-md bg-surface" wire:click.stop>
            <div class="flex items-center justify-between border-b pb-3 mb-4">
                <h3 class="text-lg font-heading font-medium text-text-primary">Detail Penyedia</h3>
                <button wire:click="closeModal" class="text-text-secondary hover:text-text-primary">×</button>
            </div>

            <div class="text-sm text-text-secondary py-2 border-b mb-4">
                <strong>Nama:</strong> {{ $badanUsaha->nama_badan_usaha }}
            </div>

            <div class="border-b border-gray-200 mb-6">
                <nav class="-mb-px flex space-x-8">
                    <button wire:click="$set('activeTab', 'profile')"
                            class="py-2 px-1 border-b-2 font-medium text-sm {{ $activeTab === 'profile' ? 'border-primary-600 text-primary-600' : 'border-transparent text-text-secondary' }}">
                        Administrasi
                    </button>
                    <button wire:click="$set('activeTab', 'kbli')"
                            class="py-2 px-1 border-b-2 font-medium text-sm {{ $activeTab === 'kbli' ? 'border-primary-600 text-primary-600' : 'border-transparent text-text-secondary' }}">
                        KBLI
                    </button>
                    <button wire:click="$set('activeTab', 'pengurus')"
                            class="py-2 px-1 border-b-2 font-medium text-sm {{ $activeTab === 'pengurus' ? 'border-primary-600 text-primary-600' : 'border-transparent text-text-secondary' }}">
                        Pengurus
                    </button>
                </nav>
            </div>

            <div class="max-h-96 overflow-y-auto">
                @if($activeTab === 'profile')
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <strong>Nama:</strong> {{ $badanUsaha->nama_badan_usaha ?? '-' }}<br>
                            <strong>NPWP:</strong> {{ $badanUsaha->npwp ?? '-' }}<br>
                            <strong>NIB:</strong> {{ $badanUsaha->nib ?? '-' }}
                        </div>
                        <div>
                            <strong>Alamat:</strong> {{ $badanUsaha->alamat_badan_usaha ?? '-' }}<br>
                            <strong>Kabupaten:</strong> {{ $badanUsaha->kabupaten ?? '-' }}<br>
                            <strong>Email:</strong> {{ $badanUsaha->email ?? '-' }}
                        </div>
                    </div>
                @elseif($activeTab === 'kbli')
                    @if($badanUsaha->kbli2017->count() > 0 || $badanUsaha->kbli2020->count() > 0)
                        <div class="space-y-4">
                            @foreach($badanUsaha->kbli2017 as $item)
                                <div class="border p-3 rounded">
                                    <strong>KBLI 2017:</strong> {{ $item->subklasifikasi_layanan ?? '-' }}<br>
                                    <strong>Kode:</strong> {{ $item->kode ?? '-' }}
                                </div>
                            @endforeach
                            @foreach($badanUsaha->kbli2020 as $item)
                                <div class="border p-3 rounded">
                                    <strong>KBLI 2020:</strong> {{ $item->subklasifikasi_layanan ?? '-' }}<br>
                                    <strong>Kode:</strong> {{ $item->kode ?? '-' }}
                                </div>
                            @endforeach
                        </div>
                    @else
                        <p class="text-center text-text-secondary">Tidak ada data KBLI</p>
                    @endif
                @elseif($activeTab === 'pengurus')
                    @if($badanUsaha->pengurus->count() > 0)
                        <div class="space-y-3">
                            @foreach($badanUsaha->pengurus as $item)
                                <div class="border p-3 rounded">
                                    <strong>{{ $item->nama_pengurus ?? '-' }}</strong><br>
                                    <span class="text-sm text-text-secondary">{{ $item->jabatan ?? '-' }}</span>
                                </div>
                            @endforeach
                        </div>
                    @else
                        <p class="text-center text-text-secondary">Tidak ada data pengurus</p>
                    @endif
                @endif
            </div>

            <div class="mt-6 text-right border-t pt-4">
                <button wire:click="closeModal" class="px-4 py-2 bg-gray-500 text-white rounded-md hover:bg-gray-600">
                    Tutup
                </button>
            </div>
        </div>
    </div>
    @endif
</div>
