<div class="space-y-6">
    <!-- Search Section -->
    <div class="bg-surface rounded-lg shadow-sm border border-gray-200 p-6">
        <h3 class="font-heading text-lg font-medium text-text-primary mb-4">Pencarian Penyedia Jasa Konstruksi</h3>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
            <!-- Search Input -->
            <div class="md:col-span-2">
                <label for="search" class="block text-sm font-medium text-text-primary mb-2">
                    Parameter Pencarian
                </label>
                <input
                    type="text"
                    id="search"
                    wire:model.live.debounce.300ms="search"
                    placeholder="Masukkan kata kunci pencarian..."
                    class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:ring-primary-500 focus:border-primary-500 bg-surface text-text-primary"
                >
            </div>

            <!-- Search Type -->
<div>
                <label class="block text-sm font-medium text-text-primary mb-2">Jenis Pencarian</label>
                <select wire:model.live="searchType" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:ring-primary-500 focus:border-primary-500 bg-surface text-text-primary">
                    <option value="NamaBadanUsaha">Nama Badan Usaha</option>
                    <option value="NPWP">NPWP</option>
                </select>
            </div>
        </div>

        @if($search)
            <div class="mt-4 flex items-center text-sm text-text-secondary">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                </svg>
                Mencari "{{ $search }}" berdasarkan {{ $searchType === 'NPWP' ? 'NPWP' : 'Nama Badan Usaha' }}
            </div>
        @endif
    </div>

    <!-- Results Section -->
    <div class="bg-surface rounded-lg shadow-sm border border-gray-200">
        <div class="px-6 py-4 border-b border-gray-200">
            <div class="flex items-center justify-between">
                <h3 class="font-heading text-lg font-medium text-text-primary">
                    Daftar Penyedia Jasa Konstruksi
                </h3>
                <div class="text-sm text-text-secondary">
                    Total: {{ $badanUsaha->total() }} data
                </div>
            </div>
        </div>

        <!-- Loading State -->
        <div wire:loading.delay class="p-6">
            <div class="flex items-center justify-center space-x-2">
                <div class="animate-spin rounded-full h-5 w-5 border-b-2 border-primary-800"></div>
                <span class="text-text-secondary">Mencari data...</span>
            </div>
        </div>

        <!-- Table -->
        <div class="overflow-x-auto" wire:loading.remove.delay>
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-text-secondary uppercase tracking-wider">No</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-text-secondary uppercase tracking-wider">Nama Badan Usaha</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-text-secondary uppercase tracking-wider">NPWP</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-text-secondary uppercase tracking-wider">NIB</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-text-secondary uppercase tracking-wider">Kabupaten</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-text-secondary uppercase tracking-wider">Aksi</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($badanUsaha as $index => $item)
                    <tr class="hover:bg-gray-50 transition-colors duration-150">
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-text-primary">
                            {{ $badanUsaha->firstItem() + $index }}
                        </td>
                        <td class="px-6 py-4 text-sm font-medium text-text-primary">
                            <div class="max-w-xs truncate" title="{{ $item->nama_badan_usaha }}">
                                {{ $item->nama_badan_usaha ?? '-' }}
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-text-primary">
                            {{ $item->npwp ? Str::mask($item->npwp, '*', -5) : '-' }}
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-text-primary">
                            {{ $item->nib ?? '-' }}
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-text-primary">
                            {{ $item->kabupaten ?? '-' }}
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                                        <button
                                wire:click="$dispatch('loadDetail', { id: {{ $item->id }} })"
                                class="inline-flex items-center px-3 py-1 border border-transparent text-sm leading-4 font-medium rounded-md text-primary-600 hover:text-primary-900 hover:bg-primary-50 transition-colors duration-150"
                            >
                                <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                                </svg>
                                Detail
                            </button>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="6" class="px-6 py-8 text-center">
                            <div class="flex flex-col items-center space-y-2">
                                <svg class="w-12 h-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                </svg>
                                <p class="text-text-secondary">
                                    @if($search)
                                        Tidak ada data yang ditemukan untuk pencarian "{{ $search }}"
                                    @else
                                        Belum ada data penyedia
                                    @endif
                                </p>
                            </div>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        @if($badanUsaha->hasPages())
        <div class="px-6 py-4 border-t border-gray-200">
            {{ $badanUsaha->links() }}
        </div>
        @endif
    </div>
</div>
