
<div>
    <style>
        table{
            width: 100%;
        }
    td{
        padding: 5px 10px;
        border: 1px solid #ddd;
        font-size: 13px;
    }
    th{
        padding: 5px 10px;
        border: 1px solid #ddd;
        font-size: 14px;
    }
</style>
    @if($showModal && $tk)
    <div class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50" wire:click="closeModal">
        <div class="relative top-20 mx-auto p-5 border w-11/12 md:w-3/4 shadow-lg rounded-md bg-surface" wire:click.stop>
            <div class="flex items-center justify-between border-b pb-3 mb-4">
                <h3 class="text-lg font-heading font-medium text-text-primary">Detail Tenaga Ahli</h3>
                <button wire:click="closeModal" class="text-text-secondary hover:text-text-primary">×</button>
            </div>

            <div class="text-sm text-text-secondary py-2 border-b mb-4">
                <strong>Nama:</strong> {{ $tk->nama }}
            </div>

            <div class="border-b border-gray-200 mb-6">
                <nav class="-mb-px flex space-x-8">
                    <button wire:click="$set('activeTab', 'ska')"
                            class="py-2 px-1 border-b-2 font-medium text-sm {{ $activeTab === 'ska' ? 'border-primary-600 text-primary-600' : 'border-transparent text-text-secondary' }}">
                        SKA
                    </button>
                    <button wire:click="$set('activeTab', 'skk')"
                            class="py-2 px-1 border-b-2 font-medium text-sm {{ $activeTab === 'skk' ? 'border-primary-600 text-primary-600' : 'border-transparent text-text-secondary' }}">
                        SKK
                    </button>
                    <button wire:click="$set('activeTab', 'skt')"
                            class="py-2 px-1 border-b-2 font-medium text-sm {{ $activeTab === 'skt' ? 'border-primary-600 text-primary-600' : 'border-transparent text-text-secondary' }}">
                        SKT
                    </button>
                </nav>
            </div>

            <div class="max-h-96 overflow-y-auto">
              
                @if($activeTab === 'ska')
                    @if($tk->tenaga_ska->count() > 0)
                        <div class="space-y-4">
                            <table>
                                <tr>
                                    <th>Subkualifikasi</th>
                                    <th>Kualifikasi</th>
                                    <th>Asosiasi</th>
                                    <th>Provinsi Registrasi</th>
                                    <th>Tgl Terbit</th>
                                    <th>Tgl Habis</th>
                                    <th>Status</th>
                                </tr>
                            @foreach($tk->tenaga_ska as $item)
                               <tr>
                                <td>{{$item->subklasifikasi}}</td>
                                <td>{{$item->kualifikasi}}</td>
                                <td>{{$item->asosiasi}}</td>
                                <td>{{$item->provinsi_registrasi}}</td>
                                <td>{{$item->tgl_terbit}}</td>
                                <td>{{$item->tgl_habis}}</td>
                                <td>{{$item->status}}</td>
                               </tr>

                            @endforeach
                        </table>
                           
                        </div>
                    @else
                        <p class="text-center text-text-secondary">Tidak ada data SKA</p>
                    @endif
                @elseif($activeTab === 'skk')
                    @if($tk->tenaga_skk->count() > 0)
                        <div class="space-y-4">
                            <table>
                                 <tr>
                                    <th>Jabatan Kerja</th>
                                    <th>Jenjang</th>
                                    <th>Asosiasi</th>
                                    <th>LSP Penerbit</th>
                                    <th>Tgl Terbit</th>
                                    <th>Tgl Habis</th>
                                  
                                </tr>
                            @foreach($tk->tenaga_skk as $item)
                               <tr>
                                <td>{{$item->jabatan_kerja}}</td>
                                <td>{{$item->jenjang}}</td>
                                <td>{{$item->asosiasi}}</td>
                                <td>{{$item->lsp_penerbit}}</td>
                                <td>{{$item->tgl_terbit}}</td>
                                <td>{{$item->tgl_habis}}</td>
                               </tr>

                            @endforeach
                        </table>
                           
                        </div>
                    @else
                        <p class="text-center text-text-secondary">Tidak ada data SKK</p>
                    @endif
                @elseif($activeTab === 'skt')
                    @if($tk->tenaga_skt->count() > 0)
                        <div class="space-y-4">
                            <table>
                                 <tr>
                                    <th>Subkualifikasi</th>
                                    <th>Kualifikasi</th>
                                    <th>Asosiasi</th>
                                    <th>Provinsi Registrasi</th>
                                    <th>Tgl Terbit</th>
                                    <th>Tgl Habis</th>
                                  
                                </tr>
                            @foreach($tk->tenaga_skt as $item)
                               <tr>
                                <td>{{$item->subklasifikasi}}</td>
                                <td>{{$item->kualifikasi}}</td>
                                <td>{{$item->asosiasi}}</td>
                                <td>{{$item->provinsi_registrasi}}</td>
                                <td>{{$item->tgl_terbit}}</td>
                                <td>{{$item->tgl_habis}}</td>
                               </tr>

                            @endforeach
                        </table>
                           
                        </div>
                    @else
                        <p class="text-center text-text-secondary">Tidak ada data SKT</p>
                    @endif
                @endif
            </div>

            <div class="mt-6 text-right border-t pt-4">
                <button wire:click="closeModal" class="px-4 py-2 bg-gray-500 text-white rounded-md hover:bg-gray-600">
                    Tutup
                </button>
            </div>
        </div>
    </div>
    @endif
</div>
