<div class="space-y-6">
    <!-- Search Section -->
    <div class="bg-surface rounded-lg shadow-sm border border-gray-200 p-6">
        <h3 class="font-heading text-lg font-medium text-text-primary mb-4">Pencarian Tenaga Ahli</h3>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <!-- Search Input -->
            <div>
                <label for="search" class="block text-sm font-medium text-text-primary mb-2">
                    Parameter Pencarian
                </label>
                <input
                    type="text"
                    id="search"
                    wire:model.live.debounce.300ms="search"
                    placeholder="Masukkan nama tenaga ahli atau kualifikasi..."
                    class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:ring-primary-500 focus:border-primary-500 bg-surface text-text-primary"
                >
            </div>

            <!-- Add Button -->
            <div class="flex items-end">
               <!--  <button  style="background: blue;"
                    wire:click="createNew"
                    type="button"
                    wire:loading.attr="disabled"
                    class="w-full md:w-auto px-4 py-2 bg-primary-600 text-white rounded-md hover:bg-primary-700 disabled:opacity-50 transition-colors duration-150"
                >
                    <span wire:loading.remove class="flex items-center">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                        </svg>
                        Tambah Tenaga Ahli
                    </span>
                    <span wire:loading class="flex items-center">
                        <svg class="animate-spin -ml-1 mr-3 h-4 w-4 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                            <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                        </svg>
                        Loading...
                    </span>
                </button> -->
            </div>
        </div>

        @if($search)
            <div class="mt-4 flex items-center text-sm text-text-secondary">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                </svg>
                Mencari "{{ $search }}"
            </div>
        @endif
    </div>

    <!-- Results Section -->
    <div class="bg-surface rounded-lg shadow-sm border border-gray-200">
        <div class="px-6 py-4 border-b border-gray-200">
            <div class="flex items-center justify-between">
                <h3 class="font-heading text-lg font-medium text-text-primary">
                    Daftar Tenaga Ahli
                </h3>
                <div class="text-sm text-text-secondary">
                    Total: {{ $tenagaAhli->total() }} data
                </div>
            </div>
        </div>

        <!-- Loading State -->
        <div wire:loading.delay class="p-6">
            <div class="flex items-center justify-center space-x-2">
                <div class="animate-spin rounded-full h-5 w-5 border-b-2 border-primary-800"></div>
                <span class="text-text-secondary">Mencari data...</span>
            </div>
        </div>

        <!-- Table -->
        <div class="overflow-x-auto" wire:loading.remove.delay>
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-text-secondary uppercase tracking-wider">No</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-text-secondary uppercase tracking-wider">Nama Tenaga Ahli</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-text-secondary uppercase tracking-wider">Alamat</th>
                        
                        <th class="px-6 py-3 text-left text-xs font-medium text-text-secondary uppercase tracking-wider">Aksi</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($tenagaAhli as $index => $item)
                    <tr class="hover:bg-gray-50 transition-colors duration-150">
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-text-primary">
                            {{ $tenagaAhli->firstItem() + $index }}
                        </td>
                        <td class="px-6 py-4 text-sm font-medium text-text-primary">
                            <div class="max-w-xs truncate" title="{{ $item->nama }}">
                                {{ $item->nama }}
                            </div>
                        </td>
                        <td class="px-6 py-4 text-sm font-medium text-text-primary">
                            <div class="max-w-xs truncate" title="{{ $item->alamat }}">
                                {{ $item->alamat }}
                            </div>
                        </td>
                      
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                           <button
                                wire:click="$dispatch('loadDetail', { id: {{ $item->id }} })"
                                class="inline-flex items-center px-3 py-1 border border-transparent text-sm leading-4 font-medium rounded-md text-primary-600 hover:text-primary-900 hover:bg-primary-50 transition-colors duration-150"
                            >
                                <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                                </svg>
                                Detail
                            </button>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="4" class="px-6 py-8 text-center">
                            <div class="flex flex-col items-center space-y-2">
                                <svg class="w-12 h-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                                </svg>
                                <p class="text-text-secondary">
                                    @if($search)
                                        Tidak ada data yang ditemukan untuk pencarian "{{ $search }}"
                                    @else
                                        Belum ada data tenaga ahli
                                    @endif
                                </p>
                            </div>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        @if($tenagaAhli->hasPages())
        <div class="px-6 py-4 border-t border-gray-200">
            {{ $tenagaAhli->links() }}
        </div>
        @endif
    </div>

    <!-- Form Modal -->
    <livewire:tenaga-ahli.form />

    <!-- Notification -->
    <div x-data="{ show: false, title: '', message: '', type: 'success' }"
         x-show="show"
         x-on:notify.window="show = true; title = $event.detail.title; message = $event.detail.message; type = $event.detail.type || 'success'; setTimeout(() => show = false, 3000)"
         class="fixed top-4 right-4 z-50">
        <div x-show="type === 'success'" class="bg-green-500 text-white px-6 py-3 rounded-lg shadow-lg">
            <div class="font-semibold" x-text="title"></div>
            <div class="text-sm" x-text="message"></div>
        </div>
        <div x-show="type === 'error'" class="bg-red-500 text-white px-6 py-3 rounded-lg shadow-lg">
            <div class="font-semibold" x-text="title"></div>
            <div class="text-sm" x-text="message"></div>
        </div>
    </div>
</div>
