<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;

// Route::get('/', function () {
//     return view('welcome');
// });

Route::get('/', [ProfileController::class, 'home'])->name('profile.home');

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
    Route::get('/info_grafis', [ProfileController::class, 'info_grafis'])->name('profile.info_grafis');

    // Penyedia routes - Livewire version
    Route::get('/penyedia', function() {
        return view('penyedia.livewire-index');
    })->name('penyedia.index');

    // Tenaga Ahli routes
    Route::get('/tenaga-ahli', function() {
        return view('tenaga-ahli.index');
    })->name('tenaga-ahli.index');

   

    // OPD routes
Route::get('/opd', function() {
    return view('opd.index');
})->name('opd.index');

// Pekerjaan routes
Route::get('/pekerjaan', function() {
    return view('pekerjaan.index');
})->name('pekerjaan.index');

// Paket Pekerjaan routes
Route::get('/paket-pekerjaan', function() {
    return view('paket-pekerjaan.index');
})->name('paket-pekerjaan.index');
});

// Mengubah URL untuk Livewire update route
use Livewire\Livewire;

Livewire::setUpdateRoute(function ($handle) {
    return Route::post( env('LIVERIEW_URL', null).'livewire/update', $handle);
});



require __DIR__.'/auth.php';
